<?php


class Forms_TextArea extends Forms_Control
{

	//overrides
	public $Text   = "TextArea";
   
	public $Disabled = false;
	public $ReadOnly = false;
	public $WordWrap = false;



	function GetPaint()
	{
		$ret= '<textarea'
				.' name="'.$this->WebName.'"';
				
		if ( $this->Disabled==true ) {
			$ret.=' disabled ';
		}
		if ( $this->ReadOnly==true ) {
			$ret.=' readonly ';
		}
		if ( $this->WordWrap==true ) {
			$ret.=' wrap=soft ';
		} else {
			$ret.=' wrap=off ';
		}

		$ret.=' class="'.$this->StyleClass.'"'
				.' style="'
				.$this->InlineStyle
				.$this->GetDefaultStylePosition()
				.$this->GetDefaultStyleSize()
				.'">'
				.htmlentities($this->Text, ENT_QUOTES)
				.'</textarea>';
				
		return $ret;
	}
   




	

	
	
	
	
	
	
	function StoreSubmit()
	{
	
		reset ( $GLOBALS["HTTP_POST_VARS"] );
		while (list ($key, $val) = each ( $GLOBALS["HTTP_POST_VARS"] )) {

			if ( $this->WebName==$key ){
				$this->Text = html_entity_decode($val, ENT_QUOTES);
			}
		}
		
	}
	

	
	
	
	
} //end class


?>
